/*
 * Decompiled with CFR 0.152.
 */
package bootswithdefer.JDCBPool;

import bootswithdefer.JDCBPool.ConnectionReaper;
import bootswithdefer.JDCBPool.JDCConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class ConnectionService {
    private Vector<JDCConnection> connections;
    private String url;
    private String user;
    private String password;
    private final long timeout = 60000L;
    private ConnectionReaper reaper;
    private final int poolsize = 10;

    public ConnectionService(String url, String user, String password) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.connections = new Vector(10);
        this.reaper = new ConnectionReaper(this);
        this.reaper.start();
    }

    public synchronized void reapConnections() {
        long stale = System.currentTimeMillis() - 60000L;
        Enumeration<JDCConnection> connlist = this.connections.elements();
        while (connlist != null && connlist.hasMoreElements()) {
            JDCConnection conn = connlist.nextElement();
            if (!conn.inUse() || stale <= conn.getLastUse() || conn.validate()) continue;
            this.removeConnection(conn);
        }
    }

    public synchronized void closeConnections() {
        Enumeration<JDCConnection> connlist = this.connections.elements();
        while (connlist != null && connlist.hasMoreElements()) {
            JDCConnection conn = connlist.nextElement();
            this.removeConnection(conn);
        }
    }

    private synchronized void removeConnection(JDCConnection conn) {
        this.connections.removeElement(conn);
    }

    public synchronized Connection getConnection() throws SQLException {
        JDCConnection c;
        int i = 0;
        while (i < this.connections.size()) {
            c = this.connections.elementAt(i);
            if (c.lease()) {
                return c;
            }
            ++i;
        }
        Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
        c = new JDCConnection(conn, this);
        c.lease();
        this.connections.addElement(c);
        return c.getConnection();
    }

    public synchronized void returnConnection(JDCConnection conn) {
        conn.expireLease();
    }
}

